
( Sugar Cake Animation Framework )
(    Changelog    )
This document records front end facing changes made to the mod/framework

"=" Prefix (DEV/TEST only) signifies change only applies to this release chain

----- ----- ----- ----- -----
**Sugar Cake Animation Framework - Version 0.6.1 DEV**

**Fixed :**
- Tags should now set properly when Start/EndStage are used by an animation
- Start/EndStage should no longer cause the duration of stages to bug out if they are set to looping
- Potentially fixed issue with the ArousalMorph exceeding the max value
- Fixed an issue with non-looping animations where if multiple actors were present, under certain conditions the animation would progress multiple stages
- Fixed DurationWeight working backwards
- Non-looping climax animations should now have a proper duration set, allowing them to play normally
- Fixed ClimaxVar failing to play in nearly all cases, also fixed climax var for Start/EndStage not setting up their cache properly for playback, causing playback errors
  - This was a hyper complicated bug which caused undefined behavior across the board, it was caused by my caching method for optimization not caching the ClimaxVars correctly, however since it messed up the cache it was also messing up normal stages as well
- Climax animations should now save in the adjust profile properly

----- ----- ----- ----- -----
**Sugar Cake Animation Framework - Version 0.6 DEV**

**Notes :**
- This version is a complete re-build of SCake from the ground up! The entire backend has been completely changed to be more efficient, more modular, and easier to update/maintain while setting us up for a path to 1.0!
- Packaging for the Animation Framework changed, delete the old ProjectSugarCake.pak file or else things will conflict and potentially cause errors!
- Modules for previous versions of SCake will need to be re-compiled for the new SDK as the backend has changed, old modules will no longer work
- With this version, the JSON format has been re-worked and changed! For animations to register, animation packs will need their config files updated! (New templates provided with SCake)
- Setting/Adjust json saves changed into Profiles and changed format slightly, old saves won't work on the new version. Save for character saves which will reset when updating. (You can safely delete the old persist files)
- With modders now trying to experiment with adding new pals, for compatibility's sake SCake no longer assumes variants are the same and must be defined manually in the JSON config if they are expected to be compatible

**Additions :**
- The version pop-up now shows which release branch it was built under
- New packaging scheme for the framework, divided into 3 versions, SFW (Angel Cake) / R18 Human (Pound Cake) / R18 All (Sugar Cake), allowing a SFW version of the framework
  - Core mod is now called "AC_AnimFramework", the R18 additions are "AC_PoundCakeExtension" and "AC_SugarCakeExtension"
  - If you have the SugarCake extension, you do not want the PoundCake extension (SCake should overwrite PCake anyways, but generally don't install both just in-case)
  - Pound Cake is more of an experiment to play around NexusMod's rules, got the ok for a human only version but I suspect interest will be low
- The Register is now aware of what JSON file data comes from, this data is stored and reported in register errors
- "ACakeVersion", "PackName", and "PackAuthor" has been added to the top of the JSON template/format (outside animation definitions) and is recognized by the Register, Register uses PackAuthor to replace any "Author" entries without an entry (a shortcut, basically)
- Additional checks for "IsErotic" added to Parser/Register, when SEquipReq, FaceExpressClimax, or IsClimax parameters are valid, IsErotic is automatically set to true (Helps detection to prevent R18+ anims playing on SFW version)
- Parser/Register now scans Erotic content when not using Sugar Cake extension, removing what shouldn't be valid in the other cake versions
- New "TargetDuration" override option added to the StartAnimEvent API functions
  - This value overwrites the max playback duration instead of using auto-play or player setting values
- New "Interaction" style animation playback, this mode does not progress automatically and instead requires external scripts to progress the animation. (Used for interact animations like using an item or interacting with furniture)
- A lot more information added into ErrorOutput, now includes appended output for multi-step processes to better detail issues
  - This was done during the re-write and errors should be much more descriptive overall, but not all systems were able to have recursive errors
- API Function "SCake_GetSexEquip" added which grabs the SEquipTags for the specified character
- New "StartStage" to Animation Events, this stage will always try to play first, acting as an introduction stage (Recommended to do a non-looping animation here)
- New "EndStage" to Animation Events, this stage will always try to play last, for Erotic animations this stage will act as the post-climax stage if present
- "IsClimax" flag added to AnimSlot definitions to designate it as a climax
  - No functionality on its own other than flagging the animation for customizing events
- ACake now recognizes Montage Notifies through a new character anim tracker
  - Actual functionality not yet implemented, however this could be used to play soft-coded sounds, effects, change expressions, or event change character status during animation playback in the future
- API Dispatcher "ACake_ED_AnimSwitch" which triggers any time an event switches animations
  - Also triggers the first time an event starts playing an animation, however "ACake_ED_AnimStart" is better for this purpose
- Register now sends a report message if it found no animations before despawning (useful for error reporting)
- Characters now go back to their original positions before an animation started playing (Prevents various positional bugs and exploits using SCake's ability to move characters)
- "ACake_AnimPlayer_ED_AnimStart/AnimEnd/AnimSwitch/AnimEventSwitch" and "SCake_AnimPlayer_ED_EventClimax" to the AnimEventPlayer which are the same as the global versions but attached directly to the animation player so they only report when that specific events triggers them
- Adjusting all stages of an animation event is now an option in the adjust menu, now defaults to disabled
  - While enabled, all stages of an animation will adjust by the same amount
  - Starting Arousal is randomized just like SexHeat and Sexual Pleasure (Between 0 - 100)
- "ACake_GetAnimEventByID" API Function added which gets the AnimEventObj by its UniqueID
- "ACake_SetEventEnabledState" API Function added which sets an AnimEvent as Enabled/Disabled
- While Debug inputs enabled, animation progression can now be disabled in the anim adjustment menu
- Debug inputs for getting targets now reports if the target is already added (instead of saying nothing)
- Framework now attempts to disable AI functions and clear certain flags for participants in animations to prevent various game and animation bugs
  - This change is still mostly experimental, let me know if it causes any issues!
- Framework now attempts to remove characters from combat when they enter an animation
  - Similar to AI function changes, I have no idea if this will have negative side-effects
- NPCs will now hide their weapon during animations
  - Tried this same method on player, however there's some animation blending issues which the NPCs don't have that need to be solved first
- Masturbation count is now tracked
  - When entering a solo erotic animation, this count increases by 1
- API Dispatcher "SCake_ED_CharTrackEnabled/Disabled" now also returns the CharStatus object that was enabled/disabled
  - Additionally updated to both call after the enable/disable script
- Arousal now generates in AnimEvents (Replaces SexHeat increasing in AnimEvents)
- Framework now stores what SEquip tags are registered in general for use in menus
- New "Force Player Sex Equip Tags" menu to Preferences menu which allows you to select specific tags to force-enable for player compatibility checking
  - This is a new method to overwriting the player's in-game gender and allow any SEquip from being added from registered SEquip tags
- Settings now save in a global profile instead of being per-world
- Added a ton of settings to the Settings Save JSON
- New overhauled adjustments backend with new identifiers, now accounts for CharacterID/BPClass and Scale to make more accurate adjustment profiles and allow different sizes/variants to have their own profile
- Adjust saves are now global and no longer tied to world (However there is a split save between ACake and SCake saves)
- Debug functions for adding SexHeat now shows a notification for each increase and shows the new SexHeat amount
- "CharStatus_ED_Climax" Dispatcher added to CharStatus object for tracking when a specific character climaxes
- "CharStatus_ED_Aroused" Dispatcher added to CharStatus object for tracking when a specific character becomes aroused
- "ObjectTarget" added to StartAnim and FindPotentialAnimEvents functions (as well as the compatibility checker)
  - This is specifically to start/find furniture animations, will require the AnimEvent to have the specified actor's ID in its compatibility for it to be considered playable
- "ObjectTarget"/Furniture animation support added to the Animation Player
  - In the JSON config, animations can specify an ObjectID to match with in-game actor classes along with the required offsets
  - ObjectTarget's origin point plus the provided offsets become the new AnimationRoot location
- Debug controls now allow targeting objects, anything hit that is not detected as a character will be registered as an Object Target
  - Note this makes targeting things a bit trickier as object targets could be accidentally set relatively easily under certain circumstances
  - Clearing targets will also clear the object target
- Blocked Tags can now be accessed in the Preference Settings menu, blocked tags will automatically add to excluded tags when modules search for compatible animations but won't prevent forced animations from modules
- Blocked Characters can now be accessed in the Preference Settings menu, blocked characters will be considered incompatible for all erotic animations except forced animations from modules
- New Erotic Status Settings menu, this now holds settings related to SCake Status and many options were moved into this menu
- "Force Character Rescale" option to System Settings menu, this setting will try and rescale characters during animations to the set size in animations for improved alignment and keep intended sizes
  - Not all animations will define a size, in cases where no size is set this option will try and use scale limits to try and resize accordingly, if no scale limits are set then this setting is ignored
- "Free Cam Speed" option to System Settings menu, this determines how quickly the Free Cam moves while controlling an Animation Event
- "Register Max Process Count" option to System Settings menu, this determines how many processes the Register can run per-frame
- "Hide UI in Animations" option to System Settings menu, this toggles whether to hide the in-game UI during animations or not
- "Arousal For Aroused" option to Status Settings menu, this sets how high a character's Arousal must be to be considered Aroused and trigger aroused effects
- "Climax Loop Duration" option to System Settings menu, this determines how long a looping climax animation should play for before stopping, does not affect non-looping climax animations
- "Arousal Gain in EroAnims" option to Status Settings menu, determines how much Arousal is gained passively during Animation Events
- "Heat to Min Arousal Rate" option to Status Settings menu, sets what percentage of Sex Heat is used as the minimum Arousal a character will always have
- "Pleasure For Climax" option to Status Settings menu, sets what Sexual Pleasure to reach to attempt to trigger a climax
- "Post Climax Loop Duration" option to System Settings menu, sets how long Post Climax Animations will play before ending the Animation Event if the animation is looping
- "Status Update Tick Rate" option to the System Settings menu, sets how often SCake Character Status updates
- "Tracker Scan Rate" option to the System Settings menu, sets how often SCake's tracker will manually scan for new characters
- Validity check now checks if character is 'active' through internal game check to prevent non-active actors from being pulled into animations
- New Debug Menu added and moved Debug Input toggle here, this menu will show debug options and information
- Info about Debug Targets now show in the Debug Menu, giving information to help with understanding Compatibility and Status
- "Erotic Debug Anims" added to Debug Menu, determines if animations started with Debug Input should be Erotic or not
- "Reset to Defaults" and "Include Defaults" added to the Human Gender Defaults menu, Reset will reset the genders to SCake's default configuration while Includes will add SCake's female definitions to your own changes
- Added new exponential Arousal decay system
  - Arousal will decay after a short delay and decrease faster the longer Arousal is above minimum
  - Whenever Arousal either increases or reaches minimum, the arousal decay speed will reset
- "Arousal Decay Delay" added to Status Settings, determines the delay before Arousal starts decaying
- "Arousal Decay Rate" added to Status Settings, determines how quickly Arousal will start to decay at, increasing over time
- Implemented an improved version number display, converting the int-based value into a readable semantic version

**Changes :**
- Changed how CharacterIDs are grabbed, SCake no longer removes suffix's and many prefixes or assumes they are equals
  - As custom pals could be added to the game with conflicting assets but similar names, we can't assume they are now compatible
  - JSON configs will need to include variants CharacterIDs if they are compatible, such as PalName_Cryst
- A large number of API names and descriptions, too many to list (check updated SDK for more details)
- Wording in many aspects have been changed, too many to list
  - 'Pal' was often changed to 'char', versions should show the appropriate names, removed direct references to Pals where it didn't line up with base-game assets
- Register no longer stores invalid entries, no longer necessary since the Parser and Register were merged
  - Minor speed-up but makes pulling invalid data for debugging more difficult, don't think anyone used this however
- Separated SexHeat and Arousal into their own variables
  - SexHeat now determines how 'effective' arousal is and its minimum value/generation rate
  - Arousal is a new gameplay focused variable
- Simplified gender block settings to work off 'assumed' gender from SEquips, no longer checks penetration
  - Characters having both vagina and penis count as male, characters with neither are assumed female, for simplicity's sake
  - Tags should be used for more advanced blocking going forward
 - Non-Erotic animations can now always be ended from the adjustments menu (Does not apply to interact animations)
 - Revised info shown in Event Description when viewing them in the menu, adding some info and removing some info
- Invulnerability during animations setting now only applies to Erotic Animation Events
  - Allows more gameplay oriented Non-Erotic animations to be used with better flexibility (modules can toggle their own invulnerability), also prevents exploitative uses of mods in unintended ways
- SexHeat will now only ever increase but reset to 0 after a Climax
- SexHeat randomization changed from 0-100 to 0-200
  - This technically increases the chance of running into hornier characters, will probably make this configurable in the future
- Arousal based-Morphs are now based on the new Arousal stat instead of SexHeat
- Disabled Events are now treated slightly differently, when disabled they will fail when searching for potential animations but scripts can still pull the AnimEvent by ID and force it to play
  - This is so mods which add events for interactions can still play the animation without the user having it show up randomly, a 'system' flag will be added later to better support this
- Free cam starts higher off the ground, position/height now based on the first character passed to start the animation (was just going off Slot 0)
- Human/NPC display name method changed, should return a readable name more often
  - This probably needs testing, I don't know what names it failed to grab but if anything returns stuff like "NPC_Whatevers" with underscores in it, it's probably a failed name grab
- Player display name method changed, should now display names for all players rather than just the local player
  - Technically a multiplayer fix, but multiplayer still doesn't work correctly
- CharStatus objects for non-persistent characters will now stick around for 60 seconds after disabling so you can still pull data from them for a bit (similar to AnimEventPlayer)
- Persist checks now attempt to use the game's internal save map for IDs to check whether something should persist or not
  - Not sure how reliable my current method is as I've only partially reversed the game's saving system, will need research
- SCake_GetAllTracked is now "SCake_GetAllCharStatus" and returns all SCake_CharStatus objects currently Enabled
- Climax dispatchers now trigger after the climax effect has already applied
- Class (BPClass) is now grabbed directly from the character's Actor reference, enabling compatibility with custom characters not spawned through the game's native systems and fixing issues with bugged out saves which cull CharacterIDs
- Debug Input is now disabled by default (can be enabled in the Debug Menu)
- Updated 'default' female NPC character list for initial configuration
  - This is no-doubt still missing some, I just added any that contained 'female' in the name

**Removals :**
- "ACake_ED_AnimStart" and "ACake_ED_AnimEnd" no longer return the CharList directly, pull from the AnimEventPlayer Reference instead
- "SCake_InterpretError" no longer exists, error outputs made into Strings directly
  - Originally this was here to simplify making errors consistent, but I found it somehow even more cumbersome to use and also make multi-mod development more jarring
- "ReportRegFails" no longer in settings, instead register reports will now always show to help users report issues
  - Before, info was too obscured and confusing for some users to enable, this should allow more and better reports from users when issues do arise
- Start AnimEvent API Functions no longer select a random animation if an invalid AnimEvent is passed
  - Prevents unexpected behavior if a module's selected animation ends up invalid
- Explicitly setting and searching for ActType/Location removed from start anim functions
  - This was always confusing to both use and maintain, a better strategy moving forward is relying on tags and maybe manual checking by modules when getting events so it doesn't slow down compatibility checking
  - This also comes with a sizable performance improvement for the compatibility checker
- "HasPostClimax" removed from JSON Format
  - Replaced by "EndStage", when this is defined it will act as the post climax animation
- SexHeat no longer has the rise and lowering mechanic
  - With the introduction of Arousal as its own status, SexHeat is being simplified
- Removed several API Functions and moved them into the SCake_CharStatus object, use "SCake_GetCharStatus" to get the object and pull stats instead, removed functions include SCake_AddSexHeat, SCake_CheckStat_Pleasure, SCake_Stat_AddPleasure, SCake_CheckStat_SexHeat, SCake_CheckStat_ArbString, SCake_Stat_ArbChangeString, SCake_GetSEquip
- Removed API Function SCake_InterpretError as it's no longer needed
- SexHeat no longer generates in AnimEvents (replaced with mechanic for Arousal)
- Removed the Dynamic Gender spawning system and menu options (replaced by SEquip Tags handled by model replacers)
- Removed Player Gender setting (replaced by new Force Sex Equip Tags menu)

**Fixes :**
- Fixed characters trying to continue their work or pathing while still in an animation, causing them to glitch out under certain conditions
- When the Name parameter is missing from the JSON config, it should now properly show the UniqueID as the name instead
  - This was initially implemented at the display level, but now sets the actual value for the animation so it should be consistent now
  - Note : This doesn't apply to stages since stages do not have a UniqueID
- New backend and transfer/re-write allowed major optimizations and clean-up across the board
  - Uncertain how much impact this will have in practical terms, but should allow more headroom for advanced features
- Compatibility Checker re-written with new backend, should have major performance improvements
- "ACake_ED_AnimEventSwitch" now properly triggers when events switch rather than the Docs saying it would but actually triggering like "ACake_ED_AnimSwitch" does now
  - Technically also fixed "ACake_ED_AnimSwitch" not always showing when animations switch as well
- Fixed a bug where the player is not recognized properly by the framework
  - Could happen if a game takes too long to load and initialization happens before the player exists
  - Framework now grabs the player from the base-game every time it's used to prevent this bug (instead of storing it)
- Debug input's target message always ending with a ' , '(
  I was just lazy before, fixed it while transferring things over)
- Erotic solo animations should no longer show 2 "End Animation" entries when debug input is enabled
- Adjustments for anims should now properly store and persist
  - Was only storing a single adjustment and wasn't saving, fixed while re-writing to the new backend for them
- Should now properly detect the 'black screen' before the title screen as not in-game, stopping the framework from running unnecessary functions (such as the Register)
- Adjustments Increments should no longer go all the way to 0 (Stops at 0.1)
- If a Human/NPC has a forced gender set on their character (such as through other mods or base-game alterations) then the framework should now detect it if the change was done correctly
- Tracker was re-optimized, now invalidates IDs based on delta time rather than times checked
- When the summoned pal is in an animation, should now prevent the player from switching/returning the pal
- "TraceForChar" and debug controls should now be able to target summoned/party characters (Fixed trace issue for selection, hold functions unchanged)
- Disabling Debug Input now clears Debug Targets so they don't get stuck in memory

----- ----- ----- ----- -----
**SCake Version 0.5.1 DEV (Beta)**

**Notes :**
- This version changes some API call types, modules will need to be updated for the new SDK and recompiled or else they may cause a crash
- This version has several backend changes and alters various parameters and how they're treated. Some sections of the JSON may need to be updated (Primarily PalSize has been removed, replaced by PalScale, new multi-definition configurations have been added, SEquipTags and ModelTags have replaced the old genders system, Slots must now align inside Animation Events)

**Added :**
- Added new morph support, "ArousedSnap" which rests at 0.0 then snaps to 1.0 when aroused, back when no longer aroused
- API Function "SCake_SetModelTags" which sets model tags to a palcomp through a given reference, used in compatiblity checking
- API Function "SCake_AddModelTags" which adds model tags to a PalComp through a given reference, used in compatibility checking
- API Function "SCake_RemoveModelTags" which removes model tags to a PalComp through a given reference, used in compatibility checking
- API Function"SCake_ResetModelTags" which resets the given Model Tags to their default state before any external alterations, useful for resetting the SexEquip setting
- PalComp variable "BaseGender" which stores the base-game gender after SCake's auto conversions
- PalComp variable "SexEquipList" which shows which Sex Equips this character has (used for compatibility checking)
- PalComp variable "SexEquipPreset" which shows what gender preset was used, only includes Male or Female, none if they are neither
- PalComp variable "ModelTags" which stores the model tags currently assigned (used for compatibility checking)
- PalCompe variable "ModelEquipTags" which stores the model equip tags currently assigned (used for compatibility checking)
- Added New SexEquip System which uses default gender tags and model tags to determine what animations should be compatible and detect gender in a more dynamic way (Instead of set genders, multiple tags are applied for what type of equipment they may have, this also allows more dynamic equipment types such as 'DoublePenis' for characters with dual slongs, Altermatic will support these features in Altermatic 0.5.0 DEV)
- API Function "SCake_SendNotif" sends a notification to UniPalUI through SCake (Replaces SCake_SendReportMessage previous functionality)
- API Function "SCake_SendReportMessage" now sends the report message to the UE4SS console if pressent, changes functionality to being a debug and error reporting message report function
- Overwrite functions into the JSON Format/Templates allowing come sets to have different parameters

**Changed :**
- Completely overhauled how SCake's animation register and playback system works, now defines animations as individual character animations with "AnimSet"s for compatibility checking, Animation Events now handle all interactions between multiple characters, these changes allow much more flexibility and processes much faster
- Compatibility is now more dynamically checked to make dynamic changes to animation data viable
- SDK Objects SCake_AnimObj and SCake_EventObj completely reworked, added SCake_AnimSetObj, SCake_StageObj, and SCake_ClimaxVarObj
- API Function "SCake_StartAnimEvent" IncludedTags, ExcludeTags, and Aggressors parameter is now a Set type
- API Function "SCake_GetCompatEvents" IncludedTags, ExcludeTags, and Aggressors parameter is now a Set type
- JSON Format/Templates completely reworked with new definitions, this new format aligns with SCake's new backend system for animations and should be easier to create/maintain
  - Simplified and made names consistent across entries and the internal names/API
  - RegisterAnim has been replaced by RegisterSlotAnim, no longer holds data for multiple actors but instead holds information for an animation 'slot' and contains all information related to that specific animation
  - RegisterEvent has been replaced by RegisterAnimEvent, moved all data related to multiple actors to this new register and made things much more flexible in the process
  - (Too many changes to list here, view the new templates for more information)
- ActType and ActLocation are now Name parameters for more flexibility (Works more similarly to tags)
- Merged the parser and register for animations, hopefully resulting in a speed up (certainly simplified code)
- Flipped instances of "NonErotic" to "IsErotic", so this value must now be set to "True" to be considered Erotic, default is still false which makes things NonErotic by default

**Removed :**
- SexEquip from persist file, now re-generates when initializing the character (changed to align with new SexEquip handler)
- Old preset gender system, replaced completely with new tags system
- PalSize in the JSON config is no longer valid, replaced with PalScale which is a much more accurate system.
- ByMeshRef, which never functioned in the JSON, has been removed from the parser (This was actually parsed and stored before, but the Model Tags system should allow this type of functionality in a much better format)
- Multiple Compatibility definitions within a JSON, replaced by the new multi-definitions system and ' OR ' parameter changes (Although this feature was painstakingly added in early on in designing SCake's compatibility system, it was not only unused but turned out to be unnecessary, check was added for backwards compatibility but future compatibility settings will be defined as a Set/Object rather than an Array of Sets/Objects, old definitions, if a JSON DID use multiple, only the first entry will be accounted for)
- Animation asset loading is no longer validated in the register (already checks when trying to play anims which are not properly defined, just won't show errors when registering the animation for performance reasons)

**Fixed :**
- Register should now properly remove itself when no new animations are found for a while (destroy node wasn't connected >.>)
- Human Base Gender options should now switch properly (Input wasn't being handled properly)
- Fixed "Block Male Penetration" causing animations to play on the incorrect pals (I refactored the code and it was fixed, so still not sure why it was happening)
- Refactored and optimized animation compatibility checker and sorting code
- Climax 'outside' and 'default' should now properly assign to their set actor slot (was always setting to slot 0, climax inside still worked as inteded however)
- ClassBP not always being properly checked in the compatibility checker for Pals
- Compatibility checker checking compatibility n^2 times when an EventID was specified but was invalid (Checked potential ordering multiple times in the chain, resulting in exponential check counts)

----- ----- ----- ----- -----
**SCake Version 0.5 DEV (Beta)**

**Notes :**
- This version comes with the all new detection methods for faster, more performant, and hopefully more reliable detections for tracking and stats! If you notice new issues with these detection methods, please let me know ASAP!
- This version switched to UniPalUI for both input and UI handling, UniPalUI is now a hard requirement for SCake to have full functionality!
- Do-to saving changes and fixes to the persistence, "SaveSystem" and "SavePal" files from older SCake versions have been invalidated and will reset when loading with the new version. If you wish to keep your old save data despite the changes you can change the save file's "SCake_ModVersion" to "5000" in the associated SCake_SavePal_WorldID.json file, however a lot of data may not load.
- This version adds functional Altermatic integrations, requires Altermatic 0.4.0 DEV or newer to take advantage of them! If an older or no version is present then the integrations won't function. (Altermatic is not a requirement, just listens to calls made by SCake for certain functionality)
- Adjustment profiles have been reset since the way they are tracked and saved has changed

**Added :**
- __Create_Load_List__.bat will now try to scan .json files for UniqueAnimID and UniqueEventID to try and predict if the json config actually contains animation data (the ID is required for anims/events to register, so if they are excluded then it most likely isn't an anim config JSON)
- Started transitioning to the new Unified UI system (May release as its own framework in the future)
- Improved and re-enabled Async systems on the Register, this will drastically reduce the freeze-up on initial load but anims will take a short bit to register after the game starts up (Lock-ups can still happen depending on what anim packs you have installed and your hardware, packs with excessively large AnimJSON files will cause a lockup when loading in since the parsing of their data couldn't be fully asynced this update, solution is to create an async parser or have creators split up their json files into small chunks)
- "SCake_GetAnimObj" API Function, this returns the AnimObj which stores the data for an animation
- "SCake_GetEventObj" API Function, this returns the EventObj which stores the data for an animation
- Register now also sends the "Report" to UE4SS's console when "Set_ReportRegFails" is enabled (Still sends an in-game notification)
- Added new FreeCam mode which triggers while controlling an animation, use WASD for forward/horizontal and QE for vertical, mouse controls camera direction (Disables while the adjustment menu is open, no gamepad controls for now)
- Animation switching in Animation Control menu will now show the Animation Event details in the description box similar to the Animation Event List
- Aroused Morphs now apply to all mesh components on an character (enables replacers that use alternate replacer methods or for add-on mesh objects to have functional Aroused morphs)
- SCake will now have integrations with SCake and be able to call certain functions when required (Only available on Altermatic 0.4.0 DEV and newer!)
- "SCake_ED_SexEquipChanged" Dispatcher, this is called whenever the SexEquip for a Pal Character with an associated PalComp changes (should also trigger when a new comp is first created, however using SCake_ED_TrackPalEnabled is better for that kind of use case)
- Added new randomized gender/sex equipment spawning system, now when characters are first detected they will be assigned a random gender based on the user's preference settings (on a technical level, the sex equip is now stored in the PalComp which is used for tracking)
- Added Player gender as its own separate setting so it is no longer tied to the no-longer existing hard gender swap system
- Added an all new detection system which is replacing the old 'forced' detection system, this new method hooks into game functions and is much more reliable but still needs testing to find edge cases (the old methods still run as a fallback but at a drastically reduced rate)
- "Natural Sex Heat Rate" added to the menu, this configures how quickly Sex Heat changes naturally over time before any multipliers or additions

**Changed :**
- Most defaults were changed from their initial 'debug convenient' settings to more gameplay focused settings
  - Max Event Duration (90sec > 300sec)
  - Base Pleasure Gain Rate (120 > 80)
  - Pleasure Loss On Orgasm (80% > 95%)
- Drastically reduce default Sex Heat Gain over time (Multiplier * 1.4 per hour > 0.4 per hour) (This should reduce how often characters get aroused and allow more dynamic systems in the future, this should cause heat to 'fill' after a couple in-game days)
- Characters should no longer gain Sexual Pleasure or Sex Heat while orgasming (should freeze at the reduce value)
- "SendReportMessage" aka Notifications now show through the Unified UI system (UniPalUI)
- Most input is now handled by UniPalUI
- Animations and Events are now stored as custom Objects (SCake_AnimObj and SCake_EventObj), this allows more flexibility, is more stable to expose to the SDK, easier to use for modules, and should be faster in more complex scenarios
- Extended fail conditions for the Register to now fail when non-critical stuff is also invalid such as climax definitions (should help to ensure better compatibility, reduce confusion, and help modders debug their JSON files)
- Changed some menu wording/titles
- Completely transitioned to UniPalUI for all settings and configuration
- Completely transitioned to UniPalUI for all input registers/handling
- Changed all controls invalidating all previous keybinds
  - Debug targetting changed, now you use the debug keys to select targets and hold a key to start an animation with all targets (This allows animations with more than 2 actors at a time to be triggered in debug animations, previous trace limitations still apply)
  - Shift+K : Open Animation Control for Target (Hold for summon)
  - J : Touch Self / J with Debug : Target Self for Animation (Hold to touch self)
  - G with Debug : Target For Animation (Hold for summon)
  - H with Debug : Clear Animation Targets (Hold to start animation)
  - R in Anim : Open Adjust Menu
  - Shift+[ with Debug : Increase Sex Heat of Targets (by 10)
  - Shift+] with Debug : Decrease Sex Heat of Targets (by 10)
- Extended distance all debug keys are able to function at
- Sex Heat now caps at 1000
- During Animation Control, pleasure bars now show at the bottom of the screen and have a different look to them
- Increased the time orgasms add to animations without a climax animation to 8 seconds (was 5)
- Slightly changed default gender assignments for NPCs (All NPCs should now assign as either Male or Female with Male being the 'default')
- Re-organized the Preferences menu to show gender options first, separated Player Gender as its own option within this menu instead of a sub-menu, added appropriate menues for other additions
- Preference Settings now contains the Player Gender on it rather than in a sub-menu (it's its own setting now)
- Changed hard gender switch menus to "xxx Gender Spawn Rates" for the new dynamic gender spawning system, this menu allows you to set percentage chances for different gender spawns
- Changed hard gender switch for human characters into a "base gender" menu where you define what in-game gender each NPC type should be recognized as by default (in-game NPCs have their gender set to 'None' however SCake no longer takes in none as a gender and instead defaults to Male, for female NPCs this setting should be changed to "Female" while the rest can be left as is)
- SCake no longer uses "none" as a default gender type and instead assumes male for all undefined genders, none was removed from menu selections (Note : None is still used when defining requirements as a "no sex equip required" type setting, characters will just no longer have a 'none' option)
- Requirements for pals to persist have been made more strict to prevent non-relevant pals/npcs from accidentally being tracked while also adding additional systems and checks to make catching when a pal should be persistent much more reliable
- Adjustment profiles now account for all characters in the animation when determining a profile to use, this should prevent issues where animations are available for multiple sizes (this update resets old adjustment profiles with this change, uses scale factor which is mostly untested so hopefully it works but if not we'll have to try again with a different method)
- Changed some key values in the SaveSystem JSON (since it was being reset this update anyways, figured I could simplify it a bit and remove unnecessary prefix')

**Removed :**
- API Events "SCake_RegisterAnim" and "SCake_RegisterAnimEvent" have been removed to help streamline loading and removed some dependency on Structs (A future version of these functions will be made which allows you to directly create the necessary datamap which will work the same way JSON registration currently does, this allows more features to be utilized with BP anim registering and prevent breakage between versions)
- API Function "SCake_AdjustAnimCamPos" has been removed along with the old camera system (Replaced by freecam)
- Removed old menu and menu control (Menus are now handled by UniPalUI)
- Removed "Game Settings" from SCake's menu since it had no options within (Will return if there's ever anything to add in there)
- Removed cam position saving for animations and removed this param from the adjust profile (May be possible to add back in a new form but with the new free-cam the old system no longer functions)
- "Use Global Cam Adjustment" has been removed (Made invalid by new FreeCam)
- Hard gender switch settings and system completely removed (replaced by dynamic gender spawning system)

**Fixed :**
- __Create_Load_List__.bat will now properly run in admin mode for all users regardless of your environment set up (while in windows at least)
- __Create_Load_List__.bat now properly checks for the .json extension before adding to the list
- Anim compatibility checker was sometimes checking SexEquips in reverse, making Futa/FullFuta/Andro types not always behave as expected
- The __Create_Load_List__.bat file should now work in file paths with spaces in them
- Debug Input for starting solo target anims should now report errors like other debug functions (should be easier to understand what's happening, the lack of a notification was just an oversight)
- Registration no longer ends early when an AnimJSON used UniqueAnimID or UniqueEventID but included more than one register variable
- Co-op skills should now be disabled during player involved animations
- Andro should now proper register in compatibility for animations and not break the compat settings (was being skipped in the parser and messing up the compatibility map)
- Optimized the JSON parser to save directly to the anim/event object which is a decent speedup
- Minor optimization to JSON parser (new method is being investigated which could both save more memory and be much faster, however implementation is difficult)
- Removed a lot of unused/unnecessary data which should improve memory usage (and potentially performance?)
- Event Register should now properly compare compatibility across all animations and only register with compatible matches
- Minor optimizations to save/load functions (switched some methods around for a theoretical 10-25% speed up with their use, but will most likely have no meaningful impact overall)
- When calling "SCake_GetPalComp" with a valid pal but no associated PalComp exists, one will be created and properly initialized (This is how the internal function already worked but the API wasn't using it, now it is)
- Fixed pals not always being set as persistent when loading from the persist file, causing their stats to reset randomly after a game load (the new load system uses a persist value within the tracker itself now instead of relying on live status read from the game, the original issue was caused when loading a persistent pal's data but it was invalid so it could not check if it should persist)
- Fixed certain NPCs and Pals from events being accidentally marked as persistent (the game does not properly flag all NPCs/Pals which caused strange and hard to debug save bloat, stricter requirements and new manual persist methods work around this issue)
- Added a delay to saving to help reduce potential stutter from saving at the same time as the game does (reduces processing on a single frame and splits it up a bit better)

----- ----- ----- ----- -----
**SCake Version 0.4.2 DEV (Beta)**

**Note :**
- This update invalidates old AdjustProfiles since fixes were made.

**Added :**
- "Andro (Vagina Only)" Sex Equip definition (Can be configured in JSON for compatibility as well)
- AdjustProfile now records the last SCake_ModVersion it was saved on

**Changed :**
- Doubled debug input's trace distance (how far the game scans for selections)

**Changed/Fixed :**
- Cam Adjustments are now properly determined by EventID rather than AnimID, this should fix inconsistant behavior when animations events start on different stages (same cam position for the full event)

**Fixed :**
- AdjustProfile saving null values ("0.0") in the SaveAdjust JSON
- Cam Adjustments should now load from the SaveAdjust file properly
- AdjustProfile save duplicating/not removing redundant entries and vastly improved performance (completely re-wrote large sections to use a new system similar to how I assign custom genders)

----- ----- ----- ----- -----
**SCake Version 0.4.1 DEV (Beta)**

**Changed :**
- PocketPair reverted the packaging changes noted in the last update, this is a release with the old package format that should be compatible with the newest version of Palworld.

----- ----- ----- ----- -----
**SCake Version 0.4 DEV (Beta)**

**Notes :**
- The Sakurajima 0.3.1 update broke older mods and SCake's old loader function, this means all mods need to be re-packaged to the new format before they will work correctly, this includes Anim Packs. I've created a translation layer within SCake to the new loader format so the old JSON format should continue to work!
- This update works on major improvements to various validators to ensure animations register and playback correctly, if something was incorrectly set in animation pack .json files before but wasn't validated, they may now fail to register or behave differently

**Added :**
- Made a new Loader and Translation layer for loading animations after the "Sakurajima 0.3.1" Game Update (Old loader stopped working and this new loader won't work on older versions of the game)
- "ActLocations" has been added to API Function "SCake Get Compat Events"
- "ActLocations" has been added to API Function "SCake Start Anim Event"
- API Function "SCake Get Compat Events" now accounts for the input Aggressors and Act Types/Locations input (Note : Animations without Aggressors or ActTypes/Locations configured as expected will not return with these optional parameters)
- API Function "SCake_GetPalComp" which pulls the associated PalComp for the referenced Pal Character (PalComp stores all tracked data for a character, use this reference to pull that data without a function call)
- Added Variables to the SDK for direct reference, this allows modders to directly reference these variables without any API calls, many of which were not exposed previously by a function call
  - ProjectSugarCake Var Exposed : Pal_Player, Pal_PlayerController, SCake_ModVersion, Data_EventCompArray, System_InputState, Data_PalsInAnim, Data_PalCompMap, Key_Menu, Key_Select, Key_Up, Key_Down, Key_Left, Key_Right
  - SCake_PalComp Var Exposed : PalReference, InstanceID, CharacterID, SexualPleasure, CloseToOrgasm, SexCount, OrgasmCount, SexHeat, IsAroused
  - SCake_EventComp Var Exposed : PalList, EventID, AnimID, NonErotic, Aggressors, AnimRoot, PlayAnimDuration, PalsHaveOrgasmed
- Validator now checks for Mounted/Gliding state for all characters and checks if player characters are currently riding, will invalidate these states for animations to prevent various issues
- SCake's internal version number now shows in the start-up message pop-up
- API Dispatcher "SCake_ED_AnimSwitch" which is called any time an Animation Event switches animations
- Finished all critical validation for the Animation Register, now should check and validate all critical parameters and prevent registering broken animations while also purging some out-of-scope data (note if an anim json file has incorrect data it could still cause playback errors, this validation only prevents incomplete or invalid data passing)
- Finished validation for Animation Event Register, now checks and validates all parameters to ensure they are consistent while setting variables automatically instead of making assumptions (this means stuff like actor count, compatability, NonErotic, ect. all validate and set automatically)
- "NPCID" and "BPClass" for 'Human' characters can now optionally be used in JSON configuration for animation packs, allowing defining animations for very specific Human NPCs
- "Player" can now be used in JSON configurations for animation packs, allowing specifically only allowing the Player character (Note "Human" still includes the player)
- Positional Adjustments are now saved for each animation into an AdjustProfile, which is saved as a JSON config file named "_SCake_AdjustProfile_Slot0.json" which stores position adjustments made for each character within an animation, this allows positional adjustments to save across Events/sessions
- Camera position is now saved per-animation and saves with the AdjustProfile (the JSON that stores position adjustments)
- "Use Global Cam Adjustment" added to Preference Settings, while enabled the cam position reverts to using a global position and ignores the new AdjustProfile system
- "All HumanIDs Match" added to the System Settings, while enabled "Human NPC" IDs will all be compatible with one another (all considered as "Human" like before this update)
- "Player Matches HumanIDs" added to System Settings, while enabled the player will be compatible with all "Human NPC" IDs, including 'Human' and 'Player', otherwise only the player is only compatible with 'Player' in CharacterID compatibility checks (Enabled as the default behavior but allows future support for Player Unique animations when players use replacers that are non-human or have unique anatomy and wish to configure which anims do/don't work manually or install anim paks dedicated to that replacer)

**Changed :**
- Re-enabled animation asset validation in the register with new code that reduces redundancy and should be much more efficient (A very small number of users may experience increased load times from this change thanks to a strange UE5 bug, however that increase shouldn't be nearly as long as before, I tried running validation as a batch to work around this issue but then I ran into yet another UE5.1 bug that prevented that method from working so we're just going to have to deal with it)
- SCake's UI should now show through the Loading Screen and in-game menus (Done for debug purposes, this behavior will most likely change again in the future)
- When registering Animation or Events, Invalid Climax Variants will now cause the Anim/Event fail to register (previously just removed the climax var, to make the experience more straightforward and enable better debugging this has changed, also allows some optimizations during playback)
- Default behavior for camera handling during player involved animation events now uses the new AdjustProfile by default (may need to adjust the camera each time a new animation crops up depending on your preferences, or enable the "Use Global Cam Adjustment" setting)
- API Dispatcher "SCake_ED_AnimStart" now calls after an Animation Event has actually started playing an animation rather than during initialization, this ensures all parameters are set by the time the Dispatcher is sent

**Removed :**
- API Function "SCake_GetEventCompParams" is no longer in the API since it's made redundant with variables now exposed (removing the function is better for future compatibility)
- "Auto Save Frequency" in Game Settings removed since it's a normal in-game setting now

**Fixed :**
- Human Sex Equip settings not being switchable in the menu (Caused by mis-named callback variable)
- Added additional validation checks for when an invalid UniqueID is passed, allowing earlier failures with more predictable behavior
- If an animation fails to load during playback, an error is now displayed in the UI and the animation should end. This check also forces the animation to load before attempting playback, which should fix the rare instance of animations refusing to play even if they are installed properly
- Animation Handler should now only try to unequip equipment when an animation is starting and not when an animation ends
- Removed a fail case where the camera could be adjusted if the player bugged out the UI and was able to be in an animation while controlling another animation (This bug was inaccessible without external modules)
- When controlling an animation the menu entries should now properly update if the Animation Event switches to an animation with a different slot order


----- ----- ----- ----- -----
**SCake Version 0.3.0 DEV (Beta)**

**Notes :**
- (Note : This version temporarily removes the Animation Montage validation when registering animations. If you're making anim packs, ensure the animations play properly in-game before releasing your pack if possible.)

**Added :**
- Added : Whether Sexual Heat is rising or lowering is now recorded by the save file (was just defaulting to always increase)
- Added : API Function "SCake_StartAnimEvent" which gives access to all animation options at once with defaults (Passing no EventID will scan for a random animation to play, similar to other start anim functions)
- Added : API Function "SCake_ValidForAnim" which checks if a character is valid to start an Animation Event (I'm transitioning validity checks into these kinds of functions for more general use and reduce redundancy)
- Added : API Function "SCake_GetCompatEvents" which returns the EventID for compatible animations for the passed params
- Added : FaceExpress and FaceExpressClimax to JSON for animations while allows setting the facial expression for while the animation is playing and for orgasms respectively (check the templates for possible settings)
- Added : A hidden setting "Set_ReportRegFails" was added to the SaveSystem file, switch this to true and a long string will be sent to the report output covering all failed Anim/Event Register returns, may be useful if animations fail to register and you need to debug which failed (Note : The parser wasn't designed with these returns in mind so it may not always return useful data, to enable you must edit the SaveSystem JSON for the save you are testing on)
- Added : Compatibility checker now checks the Size parameter registered with Animation Events
- Added : "Excluded Tags" is now functional when starting animations through the API
- Added : "Preference Settings" submenu to SCake's main menu (Note : Most preference settings will be checked with the compatibility checker, if a mod starts anims while bypassing compatibility checks these may not function as intended)
- Added : "Block Female Only Anims" to Preference Settings, attempts to block/invalidate anims with 'Female on Female' intentions
- Added : "Block Male Penetrated Anims" to Preference Settings, attempts to block/invalidate anims with 'Male on Male' intentions
- Added : "Block Straight Anims" to Preference Settings, attempts to block/invalidate anims with 'Male on Female' or 'Female on Male' intentions (This also blocks all futa animations if futa flags are set)
- Added : SCake's UI now supports menu pages, can navigate between pages through a defined count
- Added : Animations should now fail to start with characters that are knocked out/dead (Technically a fix for characters partially reviving when triggering SCake animations as well)
- Added : Animations will now fail to start with characters that are in a sleeping state (Technically also a fix for sleep animation issues, if you want to start animations with sleeping characters try waking them up first)
- Added : Animations now end when a character involved takes damage
- Added : SCake now has the ability to assign arbitrary genders separate from the game's assignment, only used when specifically checking gender through SCake
- Added : "Change Gender Assignments" to the Preference Settings which 'should' list all possible CharacterIDs and allows manual assignment of SCake genders, which should save into the SaveSystem JSON file. (Note : All 'human' characters share the same ID within SCake, which includes the player as human)
- Added : "Game Settings" submenu to SCake's Main Menu which covers Palworld native settings
- Added : "Auto Save Frequency" to the Game Settings menu which alter's the in-game auto save frequency (In effect also changes SCake's auto save frequency since SCake saves alongside the game's normal save)
- Added : When animations switch during playback (like when switching stages) compatibility will be re-checked and slots re-assigned (allows dynamic Animation Event switching and arbitrary animation playback, as well as fixes slots not aligning properly through events)
- Added : Human NPCs (well, non-pals at least) now show their BP_Class when their name is displayed for easier finding/editing in SCake's settings (This change will most likely be temporary until better solutions are found, most notable place this shows up is in the control animation menu)
- Added : If no facial expression is set for an animation, default behavior will now take over with 'HalfClose' defaulting for animation playback and "Close" defaulting for orgasms
- Added : The Animation Control menu now shows the currently playing animation event
- Added : Placed an example LoadList in the AnimJSON folder, "_LoadList_Example.json" which shows how to build the load list and includes all currently known released anim packs

- Changed : SCake now loads animations synchronysly instead of async like before, this will cause the loading screen to stall and take a bit longer. (Discovered some odities and people kept complaining about the async loading, so we're just going to do it all in a single frame for now)
- Changed : SCake's default loading method for spawning the "ProjectSugarCake" actor (Using a new Subsystem Injection method which should have SCake load sooner than before but also load more reliably in multiplayer by bypassing UE4SS's injection method, UE4SS is still required and the old method is used as a fallback should subsystem injection fail)
- Changed : Sexual Heat is now gained during Erotic Animations independant of natural Sexual Heat gain, this rate is x25 stronger than natural generation and stacks
- Changed : Moved validity checks outside of the Animation Player so it runs before an animation even tries to start (this is an optimization, if you bypass the API and try to start an animation directly from the EventComp, it may now fail to start/play correctly, if there's a valid reason not to use the API ensure you are validating everything is compatible beforehand)
- Changed : "Valid For Animation" checks and systems overhauled for better modularity and additions (should also perform faster in situations where multiple compatibility checks must take place within reasonable actor limits, however large numbers of actors (more than 4) in a single scene may perform worse in some situations but will not suffer from random failures)
- Changed : Character arrays passed for animation playback should now act in a deterministic way (Compatibility is now done in a non-random way, previously while the functions were linear in comparing compatibility they were passed as TMaps, which do not resolve into a deterministic array meaning outcomes where seemingly random, the Pal Character Array is now passed directly and not altered through-out the process.)
- Changed : "Settings" are now "System Settings" to help differenciate between other new settings menus
- Changed : Animation List and Animation Event List in the menu now divides into pages with 20 entries per-page (Should be much easier to navigate, note the page sorting is not consistent because of how UE5 handles hashing)
- Changed : In instances where the game doesn't assign a gender, 'Male' will now be used by default (Only affects like, 2 human NPCs at the time of writing, felt this was the best option to make compatibility settings work closer to expectation but may still cause some strangeness. More advanced methods/exceptions will need to be implemented in the future.)

**Changed :**
- Changed/Fixed : Minor UI related things (spacing, readability, typo fixes, ect)
- Changed/Fixed : While in an Erotic Animation, characters who orgasm will now continue decreasing in Sex Heat and no longer gain the increase for being in the animation itself until reaching zero or triggering an increase in Sex Heat from another source to trigger Sex Heat back into a rising state.

**Removed :**
- Removed (Technically?) : Removed multiplier to Natural Sexual Heat generated while in Erotic Animations (Was technically broken in 0.2.1 since I had incomplete changes left in there)
- Removed : API Function "SCake_StartAnimEvent_Advanced" is no longer available, use the new "SCake_StartAnimEvent" API Function which includes all the same variables and more
- Removed : Register no longer validates if Animation Montage paths are valid (This validation step will become a debug option in the future, the current validator causes some issues for some players and extends loading time as it calls the Asset Registry, no idea why)
- Removed : Characters no longer play the "Happy" action after anims (This also added SAN and affected AI behavior, may replace with a more dynamic system)

**Fixed :**
- Fixed : Sexual Heat triggering a decrease when values were too close to 0.0 (Float percision error I didn't account for, now fixed)
- Fixed : Natural Sexual Heat progression should now properly increase instead of constantly causing a decrease. (was caused by float percision error)
- Fixed : "Valid For Animation" checks should no longer suffer from sporadic behavior/failures when comparing actor counts above 3
- Fixed : After checking the Animation Event List, closing the menu without backing out first, then entering a player involved animation should no longer get the description box stuck on-screen with the details of the last viewed Event item
- Fixed : Animation Events should now properly cull duplicate tags (worked before, but some variable changes broke the function somehow)
- Fixed : Player should no longer have duplicate references within the tracker, fixing a number of issues (May not be fixed for multiplayer, was caused by extra IDs being coded to point toward players when loading a game, current fix makes an exception and ignores these IDs)
- Fixed : Aroused morph for the player should no longer act unpredictably or 'flicker' (caused by duplicate reference fix)
- Fixed : "SCake_ED_PalAroused" will now only call if a character went from not aroused to aroused as intended (Was calling any time Sex Heat changed before)
- Fixed : Sex Heat getting stuck increasing after a character had been in an Erotic Animation
- Fixed : The animation player now calculates its on-tick/per-frame functions after physics have applied, preventing a couple of issues (Fixes some odd positional flicker when playing at high framerates, fixes expressions not always applying correctly, fixes some logic interfering with other functions which tick during physics)
- Fixed : CharacterID should no longer parse incorrectly within SCake's logic code fixing strange inconsistencies and lucky/alpha pal compatibility (For example, 'JetDragon' should not register as compatible with other other IDs that end with 'Dragon')
- Fixed : Automatic compatibiltiy checker for CharacterIDs should now work for Lucky/Boss/Variants properly (Fixed with internal CharacterID processing fix)
- Fixed : SCake should no longer run as if it's in-game when entering a game then heading back to the title screen (implemented a better title screen detection method)
- Fixed : Animation Events now correct slots while switching animations/stages so Events that don't have slots aligned through-out should now correct themselves during playback (as-in, if slot 1 switches to slot 0 from stage 1-2, the animation should correct itself rather than breaking or stopping the animation)
- Fixed : Animation Events not starting with proper offsets configured on an animation's start (was only applying offsets after the first stage had started, should now load properly on the first stage as well)
- Fixed : Animation Player should now properly track how many characters have orgasmed and how many times
- Fixed : Expressions not applying to all characters in an animation at all times, also fixed expressions applying too rapidly causing some strangeness (Most notice-able on the player if their expression was forcefully changed)
- Fixed : Animation Player calculating character positions multiple times per-frame
- Fixed : Animation Player causing some AI weirdness (SCake's Action Override had some flags set that could change AI behavior in some rare cases)

----- ----- ----- ----- -----
**SCake Version 0.2.1 DEV (Beta)**

**Added :**
- Added : API Function "SCake_TrackReturnAll" which returns all characters currently tracked by SCake (useful for initiating modules that need to apply/check status)
- Added : API Function "SCake_CheckStat_SexHeat" which returns a character's Sexual Heat stat and if they currently have enough to be aroused
- Added : API Function "SCake_Stat_AddSexHeat" which adds the specified amount to the character's Sexual Heat stat and returns their new value along with if they have enough to be aroused
- Added : API Function "SCake_Stat_ArbChangeString" which adds/changes the arbitrary string to the designated character (useful for modules to start tracking their own systems)
- Added : API Function "SCake_CheckStat_ArbString" which returns the arbitrary string associated with the given name for the designated character
- Added : ArbString element to the Pal Tracking system, this allows modules to input arbitrary strings with a name for their own use cases, these can be set to persist in the save file as well so they can exist between sessions (modders will need to be extremely careful when using persist, only use it when absolutely neccesary)
- Added : When Sexual Heat rises or lowers it will now set Sexual Heat to continue naturally in that direction (in other words, if Sexual Heat decreases it will continue to naturally decay until zero, then start going back up, alternatively if it goes up it will continue to increase, I planned this for last update but I forgot to implement it)
- Added : API Function for starting animations now check for null and empty arrays, failing faster with proper error code returns (Also a slight optimization)

**Changed :**
- Changed : If an SCake stat value is zero or null it won't be included in SCake's pal save file anymore, saving space/processing time

**Fixed :**
- Fixed : Stage Order not registering correctly when defined in the animation's .json, messing up animation playback
- Fixed : An issue with the .json parser not parsing integers correctly has been fixed (Not aware of all this affected outside Stage Order)
- Fixed : A potential soft lock issue if very specific params were passed in an animation .json import
- Fixed : Sexual Heat not being included in the save file, thus lacking persistence (I forgot to add it, sorry!)

----- ----- ----- ----- -----
**SCake Version 0.2.0 DEV (Beta)**

**Notes :**
- Note : This updated the format and data for .json files, all animation packs must be updated to the new format (I already contacted anim-pack creators, view the new templates to see the changes and format)
- Note : This update adds persistence! If the new _SCake_Save_.json files are not saving/loading properly, let me know!
- Note : This update adds support for MorphTarget Models to modify 'bodies' dynamically based on the new Sexual Heat system and for animations!

**Added :**
- Added : New "__Create_Load_List__.bat" file in AnimJSON which updates the _LoadList.json when activated (May only work on Windows, skips files starting with an underscore)
- Added : API Function "SCake_AdjustAnimCamPos" which adjusts the camera postion for the player while in an animation
- Added : API Function "SCake_TraceForPal" which uses the camera position and rotation to scan for pals, useful for debug code (Not always accurate so other methods are recommended for proper selections or interactions with pals)
- Added : API Dispatcher "SCake_ED_EventOrgasm" and "SCake_ED_PalOrgasm" which trigger when an Animation Event / Character triggers climax/orgasm
- Added : API Dispatcher "SCake_ED_PalAroused" which triggers when a character reaches enough 'Heat' to become properly aroused (Horny status ^.-)
- Added : API Dispatcher "SCake_ED_TrackPalEnabled" and "SCake_ED_TrackPalDisabled" which trigger when a pal is either enabled or disabled in the new tracking system (Note : Pals do not instantly start tracking or instantly stop tracking when they become valid/invalid, do not use this for validity checks! Use 'IsValid' through UE naively instead!)
- Added : Holding the camera control keys during animations now repeats, making adjustments easier
- Added : Report for failed JSON load now shows the json entry that failed to load
- Added : Setting "Invulnerable During Anims" which makes characters unable to be harmed during Animation Events until the end, enabled by default
- Added : Automatic CharacterID conversions for compatible pals (This means animation compatibiltiy can now define the base pal CharacterID and all variables that are compatible should be detected, input CharacterIDs for variants can still be registered with default size detection)
- Added : When animations are started characters will now move to the ground
- Added : Register now also shows fail count similar to success counts
- Added : Settings will now save into a .json file within the ~mods folder allowing them to be saved and loaded between sessions (The file name should be _SCake_SaveSystem.json)
- Added : Global camera adjustment to save file so it persists between sessions (individual camera adjustments will be added in the future when persistence/cache is set up for it)
- Added : Character Stats now track Sexual Encounter counts (Increases if there are more than 1 characters in an erotic animation)
- Added : Character Stats now track Orgasm counts (increases every time the character has an orgasm)
- Added : New dynamic pal stat tracking, all active pals should now be captured and have SCake's stats applied (Mostly just Sexual Pleasure and Heat for now)
- Added : Pal SCake Stats will now save into a .json file within the ~mods folder, enabling persistence (should save as _SCake_SavePal.json, the amount of memory this system takes over long play sessions will need to be monitored, but shouldn't be too bad)
- Added : Sexual Heat system, this affects the desire and sensitivity to sexual activity (slowly increases until orgasm is eventually reached or a heat reduction event occurs, then decreases rapidly to 0 then begins rising again with values over 100% increasing much slower)
- Added : "Aroused" Morph Target to framework, the "Aroused" morph increases as Heat increases, and sets to 100% when in erotic animations, useful for erections or arousal based body modifiers (morphtarget names could potentially become editable in the future)
- Added : Sexual Pleasure gained in erotic animations is now affected by Heat (Heat acts as a multiplier with an offset, at 0% Heat gain is at 80%, 100% = 100%, 200% = 120%, 300% = 140%)
- Added : Facial expression control to Animation Player, changes expression for supported characters while animations play (Currently sets a static expression but will be configurable by animations in future versions)
- Added : "Pleasure Stage Progression" SCake Setting, while enabled stages will also progress through average sexual pleasure from all participants based on duration weight
- Added : "Pleasure Progression Mode" to the Animation Player and SCake Settings, when enabled stages in animations are allowed to progress when the average Sexual Pleasure reaches a threshold calculated from duration weight of each stage (defaults on, only tries to progress looping animations, Max Event Duration is still respected and will progress regardless of this setting)

**Changed :**
- Changed : The Animation UI should now show the player's display name instead of "Player"
- Changed : The Animation UI should now show all players as "Player" instead of "Character" (useful in multiplayer)
- Changed : The Animation UI should now attempt to find the proper in-game name to display if no nickname is set for a pal
- Changed : Made major changes to the .json structure for easier creation, optimize parsing, and removing some variables that will go unused, old .json files will fail to register (Simplified the structure to run off order dependent arrays, so params still require slot specifications if they can contain multiple entries per-slot, check included templates to adjust your own .json files)
- Changed : JSON parser improvements/optimizations, let me know of any weirdness or fails when it shouldn't
- Changed : Limited the number of json registers per frame (will only try to load and pass 10 json sets per frame, this will slow down the register but ensures HDD users won't experience stutter when we start loading thousands of animations, register still only processes 1 animation/event per frame, this only affects sending to the register when we load the .json files)
- Changed : Register automatic start time reduced to 3 seconds (was 8 before, can be changed in the _SCake_SaveSystem_.json)
- Changed : Animation Events that fail to start animations will now immediately destroy themselves instead of waiting (optimization)
- Changed : Overhauled stats handling backend, now runs based on game time and defaults were updated to reflect this
- Changed : Pals now start with random Sexual Pleasure (No more than 20%)
- Changed : Animation Player now uses the new stats tracking system to apply and track stats like pleasure, this makes effects based on Game-Time just like other stats, Sexual Pleasure defaults was adjusted for this
- Changed : Adjusted some setting descriptions and displays to better align with systems and changes
- Changed : "Event Duration" is now "Max Event Duration", though the behavior is effectively the same but will make more sense as more features are added

**Removed :**
- Removed : "ByName" variables when registering animations (The intended system didn't work and using CharacterID instead just makes a lot more sense)

**Fixed :**
- Fixed : "Hold Down (K key) to start anim with summoned pal" now properly disables when disabling Debug Input
- Fixed : Characters in animations should no longer become eligible for another animation if multiple start anim events are triggered on them
- Fixed : Instances where animations took too long to process their start function and would fail to set all parameters properly
- Fixed : JSON loader failing to load files from the LoadList if they had .json in the entry
- Fixed : Menu scrolling offset being slightly off allowing a slow drift downward
- Fixed : Report text that shows up should now properly wrap when the text extends too far
- Fixed : Project Sugar Cake should no longer run any logic while in the Main Menu or outside a saved game (Only starts up the UI, though the API should be accessible)
- Fixed : Characters who orgasm once will not properly have their sexual pleasure checked in subsequent orgasm checks
- Fixed : Animation Player getting stuck in an orgasm loop if pleasure gain was set too high
- Fixed : FootIK interrupting normal animation flow when animating certain sections of certain characters (FootIK should be disabled during anims now)
- Fixed : Slopes causing characters to tilt while animating, causing alignment issues (Looks a bit odd given characters will now float a bit more in some situations, but much better than alignment not working)
- Fixed : Stages "Speed Mod" value should now properly affect the duration of non-looping animations
- Fixed : Climaxes not adjusting duration properly if no climax variant was included with the animation
- Fixed : General optimizations across most systems

----- ----- ----- ----- -----
**SCake Version 0.1.0 DEV (Beta)**

**Notes :**
- Note : Mods using the SCake SDK/API will need to be updated to the new API functions and reference the new actor "ProjectSugarCake"
- Note : Updated templates provided with SCake to reflect changes in data structure
- Note : Menu UI requires keyboard input for now, I messed up when building the assets so click actions don't call-back properly and were removed
- Note : Non-standard debug keys may not be reported in changelogs from this point forward (I constantly change them depending on what I'm working on, so trying to track them will get difficult as things get more complex)

**Added :**
- Added : In JSON data for 'size" parameters, entering 'default' now automatically converts to the default size param for the defined CharacterID (if one exists, otherwise None is returned)
- Added : API Event "SCake_StopAnim_EventRef" which stops the Animation Event of the given Event Reference
- Added : API Function "SCake_InterpretError" which converts a returned error code into a readable string (Used for passing into UI or make debugging easier)
- Added : API Function "SCake_GetPalAnim" which searches for a given pal and returns if they are in an animation and the event reference if so
- Added : API Function "SCake_GetEventCompParams" which returns variables from the provided Event Reference collected by functions/Dispatchers
- Added : API Dispatcher "SCake_ED_AnimStart" which sends when animations start with the Event Reference (If you store this value remember to check if it's valid and if the animation is still playing before trying to pull data)
- Added : API Dispatcher "SCake_ED_AnimEnd" which sends when animations end with the Event Reference (Do not store the returned reference and pull your data immediately as Event References will delete themselves a short bit after an animation ends)
- Added : New input system implemented with input states allowing new menu and position control (Default keys are U=Menu O=Select I=up k=Down J=Left L=Right)
- Added : Fully custom menu system implemented, use the Menu key (U by default) to open and up/down/left/right keys to interact with it (I/K/J/L by default) (No API access yet as some revisions still need to be made before it's dynamic features are usable)
- Added : "Settings" menu to SCake Main Menu
- Added : "Animation Event Duration" to the Settings Menu (controls how long Animation Events aim to last in seconds)
- Added : "Pleasure Gain Rate" to the Settings Menu (controls how quickly Sexual Pleasure is gained in Erotic Animation Events)
- Added : "Pleasure Decay Rate" to the Settings Menu (controls how quickly Sexual Pleasure is lost while not in an Erotic Animation Event)
- Added : "Pleasure For Orgasm" to the Settings Menu (controls how much Sexual Pleasure is required for this character to have an orgasm)
- Added : "Pleasure Loss On Orgasm" to the Settings Menu (controls how much Sexual Pleasure is reduced when characters have an orgasm)
- Added : "Allow Debug Input" to the Settings Menu (controls if the debug controls for SCake are enabled, will be disabled by default in the future)
- Added : Animation List to the SCake Menu which shows the "AnimName" of all Animations Registered with parameters showing in the description box (If no anim name is found the "UniqueEventID" is displayed instead)
- Added : Animation Event List to the SCake Menu which shows the "EventName" of all Animation Events Registered with parameters showing in the description box (If no anim name is found the "UniqueEventID" is displayed instead)
- Added : New Animation Menu which shows up with 'climax progress bars' for participants in the selected animation (Player animations will already be selected)
- Added : Animation menu which allows adjusting the position of characters in animations, also allows ending animations if "Allow Debug Input" is enabled (Currently does not save or have any persistence)
- Added : The Game UI will now hide by default when the player enters an animation (and should re-appear after the animation ends)
- Added : Attempts to hide the in-game UI when a player animation starts (should re-appear when the animation is over)
- Added : If a player is in an animation the camera position can now be controled with W/A/S/D/Q/E keys (Keys display in the animation UI, position saves between animations and should return to normal after the player animation ends, sometimes the game disables these keys or locks the camera and the camera function may stop working)
- Added : With debug input enabled, when holding down SCake's Down Input key (K by default) if no valid target is found SCake will now try to start an anim with the summoned pal instead (sometimes fails since the reference is invalid, seems to be a game bug but resummoning your pal usually fixes it)

**Changed :**
- Changed : UI entry point to be slightly higher up (helps make the new menu more visible when there's more entries in the list)
- Changed : SCake_StartAnimEvent_Basic is now a function and now returns if the animation started and the order+references of pals in the animation
- Changed : SCake_StartAnimEvent_Advanced is now a function and has return values just like the Basic version
- Changed : Some debug inputs were added and others changed key defaults
- Changed : Event references will remain valid for a short period after animations end instead of instantly deleting themselves (useful for pulled data after an animation ends and to allow manual scanning of animations ending without losing access to data)
- Changed : "O" debug key now opens the Animation Menu for the Target Pal

**Removed :**
- Removed : "TransformBySize" no longer includes Rotation, simplifying the data structure a small amount (Rotation is already included with the "TransformAllOffset" and there shouldn't be a need for a rotation by size)
- Removed : The Testing Angel has departed, shall she forever grace us with great debugging and moral support!

**Fixed :**
- Fixed : The default \_LoadList.json had tabs instead of spaces for the 2 additional entry slots causing errors in some cases, changed them to spaces
- Fixed : Animations were not validating in cases where all characters in an animation were valid for all slots
- Fixed : Certain parameters not being set to default when registering Animation Events with JSON when those values were not defined
- Fixed : "SpeedMod" in stages having no effect
- Fixed : Instances where the animation slot sorting would fail and result in animations breaking or not playing properly
- Fixed : Global Climax Variants not functioning properly (I forgot to connect a node >.>)
- Fixed : Drastically optimized the positioning code within the Animation Player (Also simplified implementation without any loss in functionality)
- Fixed : "TransformBySize" not parsing from JSON correctly
- Fixed : Corrected many positional issues caused by using inconsistent sources for the positioning (Still never found the 'exact' cause, but new code works so whatever)
- Fixed : Some instances where SCake's control overrides were being overwritten by external forces (SCake still fails to prevent certain actions that breaks animations)
- Fixed : Player being able to aim and throw a pal sphere while in an animation, breaking the animation playback
- Fixed : Player being able to interact with other pals while in an animation, potentially causing a soft lock state while breaking AI and animation playback
- Fixed : Characters (including the player) being able to crouch while in animations (Normally didn't break animation playback but could break AI or cause camera issues for the player)

----- ----- ----- ----- -----
**SCake Version 0.0.3 DEV (Alpha)**

**Notes :**
- Note : Data structure had changes this update, BP mods will need to be recompiled with the newest SDK release

**Added :**
- Added : JSON string and data parser for registering animations, now you can create JSON files and place them in the ~mods/AnimJSON then add the file name to the "_LoadList.json"
  - If any errors are in the JSON file's formatting it will fail to load (BP limitation)
  - Users can create their own JSON files or edit existing ones to create their own events or customize animations
  - Templates are now included with SCake's main installation
  - "\_LoadList.json" is required, however it is split up in distribution to prevent overwriting player's customized json when updating the mod
- Added : SCake_RegisterAllJSON to the API, call this to re-register all JSON animations listed in the _LoadList
- Added : "Speed Default" in registered animations now functional
- Added : "StartTime" in registered animations now functional
- Added : "Speed Mod" in Stages now functional
- Added : Keybind K (Start animation between 2 targets) will now try to start a solo animation if the same character is selected twice
- Added : "AddTags" in AnimEvent now functional (Appends additional tags to the event in addition to those added in the animations)
- Added : Animation Register now sends a total successful registered count whenever there is a pause while registering

**Changed :**
- Changed : Simplified "Act Types" and introduced "Act Location" to make registering animations easier and allow easier future additions
- Changed : "HasPostClimax" for registering events is now set to false by default
- Changed : "EquipLocation" is now a 'name' variable type to support socket/bone names and not just presets (Equip system is still non-functional)
- Changed : When characters path to animate, even a failed move (When 'Move Failed' would display) will still trigger the animation (characters will just teleport, helps the mod feel less inconsistent and buggy. This issue isn't really with the framework, it's just the quick and dirty AI which bugs out a lot.)

**Removed :**
- Removed : Anim and AnimEvent Registered messages from showing in ReportUI (Still shows failed registers with error codes)
- Removed : Equip Location enum is removed and now invalid (we parse a name variable now instead to allow custom bone/slot names)

**Fixed :**
- Fixed : Sexual Pleasure going into the negatives after an animation (accidentally shipped the wrong build which had this bug >.<)
- Fixed : Register component not automatically starting after a game load if a register API function is never called
- Fixed : "Stage Order" being ignored and erroring out if the animation playing didn't play through stages linearly
  - This Stage Order bug also broke things like play-time, animation playback, post-climax anims, all should hopefully be fixed now
- Fixed : Stage Duration for non-looping animations setting to 0 seconds when the number of stages exceeded actor count (Was a very silly mistake X.x)
- Fixed : AnimVersion number not working properly (Technically also fixed the internal version number not working correctly, but this means nothing front-end)

----- ----- ----- ----- -----
**SCake Version 0.0.2 DEV (Alpha)**

**Notes :**
- Note : Essentially Rebuilt the entire animation player and added the API systems, not everything is accessible yet but adding things in the future will be much easier once we know what to add

**Added :**
- Added : Animator now supports multiple characters at once (can play Human X Human, Pal X Human, Pal X Pal, whatever!)
- Added : AI Handler to animator to help prevent AI breaking animations / conflicting (still has minor issues)
- Added : Position handling to animator, should keep animation in the same place even if characters are pushed or pulled
- Added : New validator should auto-sort and organize animating characters
- Added : Additional validation for incompatible animations, should prevent any non-compatible animation (that have proper metadata) from playing
- Added : More advanced climax handler, now supports specific slots orgasming to trigger specified animations within a registered animation event
- Added : Pleasure gain for all characters in animations (was just the host player previously)
- Added : Support for Post Climax animation playback after climax animations, skips and just ends if no post anim is found
- Added : Support for 'included tags' and optionally requiring those tags when starting animations
- Added : Basic stat tracking for characters where it's neccesary (no persistence between save loads yet >.<)
- Added : Optimization systems to stat tracking so we only track what's needed (Basic so far, needs more advanced systems in the future)
- Added : API Base for other mods to call and use SCake functions (such as starting/stopping animations, needs to be expanded on)
- Added : API Call "SCake_StartAnimEvent_Basic" - Starts an animation between the supplied characters with minimal information
- Added : API Call "SCake_StartAnimEvent_Advanced" - Starts an animations between the supplied characters with more advanced information
- Added : API Call "SCake_StopAnim_PalTarget" - Stops any animation event the target character is involved in
- Added : API Call "SCake_SendReportMessage" - Sends a report message to SCake's report UI, visible to the player
- Added : API Call "SCake_CheckStat_Pleasure" - Returns the current Sexual Pleasure of the sent character
- Added : API Call "SCake_Stat_AddPleasure" - Adds the specified amount to the target's Sexual Pleasure
- Added : "Start animation between player and target" with default key "K"
- Added : "Start animation between 2 targets" with default key "J"
- Added : "Stop animation target is involved in" with default key "I"
- Added : Pals play their "Happy" emote/action when animation events end (more advanced emotion handling could be added in the future)

**Changed :**
- Changed : "Start solo player animation" default key changed to "L"
- Changed : "Stop player involved animation" default key changed to "O"
- Changed : "Report player's sexual pleasure" default key changed to "U"
- Changed : SyncPosition animation setting now defaults to disabled
- Changed : Animation player was re-built and has much more advanced functions now with better duration tracking
- Changed : Orgasms now add additional animation time so they don't conflict with normal stage progression
- Changed : Reduced how quickly Sexual Pleasure decays when outside an animation event

**Removed :**
- Removed : A lot of debug notifications should no longer show up in the release build (sorry if I missed any >.<)

**Fixed :**
- Fixed : Fixed animations only ever registering as "female solo human" animations
- Fixed : Animation player getting stuck and freezing indefinately if cancelled improperly
- Fixed : "Pals in Animation" tracker getting stuck if animation event was cancelled improperly
- Fixed : Animating characters getting pushed/pulled or continueing movement if already in motion when animation starts
- Fixed : Typos/misspellings in data structure

----- ----- ----- ----- -----
**SCake Version 0.0.1 DEV - Initial Release (Alpha)**

- Has ability to register animations and animation events, lacks validation
- Features limited animation player that supports solo female human animations with climax switching
- Can play solo-female animations for the player character via hotkey if any are registered (hotkey /)
- Can end animations the player is involved in via hotkey (hotkey ])
- Tracks sexual pleasure of the player character, can check with hotkey (hotkey ')
- Sexual pleasure will decay over time when not in an animation